#pragma once
#include <map>
#include <string>
#include <windows.h>
#include <vector>
#include <atlstr.h>
#include "SerialBuffer.h"

typedef enum tagSERIAL_STATE
{
	SS_Unknown,
	SS_UnInit,
	SS_Init,
	SS_Started,
	SS_Stopped,

} SERIAL_STATE;

struct StPosition {
	/// <summary>
	/// Switch value. Default value is INT_MIN.
	/// </summary>
	int S = INT_MIN;
	/// <summary>
	/// X coordinate. Default value is INT_MIN.
	/// </summary>
	int X = INT_MIN;
	/// <summary>
	/// Y coordinate. Default value is INT_MIN.
	/// </summary>
	int Y = INT_MIN;
	/// <summary>
	/// Z coordinate. Default value is INT_MIN.
	/// </summary>
	int Z = INT_MIN;
};

typedef void (*type_myCallBack) (StPosition);

class CSerialCommHelper
{
private:
	SERIAL_STATE	m_eState;
	HANDLE	m_hCommPort;
	HANDLE	m_hThreadTerm;
	HANDLE	m_hThread;
	HANDLE	m_hThreadStarted;
	HANDLE	m_hDataRx;
	bool	m_abIsConnected;
	bool    m_streamingDataStarted;
	void	InvalidateHandle(HANDLE& hHandle);
	void	CloseAndCleanHandle(HANDLE& hHandle);
	void	SetPosition(std::string);

	CSerialBuffer m_theSerialBuffer;
	CRITICAL_SECTION m_csLock;
	SERIAL_STATE GetCurrentState() { return m_eState; }
	type_myCallBack dCallback;
public:
	StPosition lastPosition;
	using String = std::string;
	using CNamesArray = std::vector<String>;
	CNamesArray ports;
	CSerialCommHelper();
	virtual ~CSerialCommHelper();
	HANDLE	GetWaitForEvent() { return m_hDataRx; }

	inline void		LockThis() { EnterCriticalSection(&m_csLock); }
	inline void		UnLockThis() { LeaveCriticalSection(&m_csLock); }
	inline void		InitLock() { InitializeCriticalSection(&m_csLock); }
	inline void		DelLock() { DeleteCriticalSection(&m_csLock); }
	inline bool		IsConnection() { return m_abIsConnected; }
	inline void		SetDataReadEvent() { SetEvent(m_hDataRx); }

	HRESULT			Read_N(std::string& data, long alCount, long alTimeOut);

	HRESULT			Write(const char* data, DWORD dwSize);
	HRESULT			Init(const char* szPortName = "COM1", DWORD dwBaudRate = 9600, BYTE byParity = 0, BYTE byStopBits = 1, BYTE byByteSize = 8);
	HRESULT			Start();
	HRESULT			Stop();
	HRESULT			UnInit();

	static unsigned __stdcall ThreadFn(void* pvParam);
	HRESULT  CanProcess();
	void setDCallback(type_myCallBack cB);
	bool detectPort();
	int init_IMMC();
	void print_hex(std::string);
	int get_int(int a, int b);
};